/*****************************************************************************
 *   target.h:  Header file for NXP LPC29xx Family Microprocessors
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2007.09.01  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/
 
#ifndef __TARGET_H 
#define __TARGET_H

#ifdef __cplusplus
   extern "C" {
#endif

/******************************************************************************/
/* BOARD DEFINITIONS                           																*/
/******************************************************************************/
/* In below definition, only one is enabled at a time */
#define HITEX_BOARD		1	/* 0 is Keil MCB2900 board */

//#define USB						0
#define USB_PORT1			1		/* 1 is port1, otherwise it's port2 */
#define USB_PORT2			1
#define HOST_PORT_NUM	2

/******************************************************************************/
/* CLOCK DEFINITIONS: See for initialization target.c													*/
/******************************************************************************/
/* The ring osc is 400Khz. */ 
#define RING_OSC			475000
/* The CCO clock is XTAL*PLL_M_VALUE=240Mhz, the Post divider is 2. So, the 
CPU_CLK is Clk_CCO/P = 120Mhz */
#define PLL_M_VALUE		15-1			/* CGU0: OSC is 16Mhz, multiplier is 15 */
#define PLL1_M_VALUE	6-1				/* CGU1: OSC is 16Mhz, multiplier is 6 */

#define CPU_CLK				120000000	/* NOTE: The CPU_CLK is set in the target.c */

/* Below PERIPH_CLK can be configured in different frequencies for 
different peripherals. This clock is used for TIMER block only. */
#define PERIPH_CLK		120000000
  

/******************************************************************************/
/* INTERNAL RAM DEFINITIONS                           												*/
/******************************************************************************/
#define IRAM0_BASE_ADDR	0x80000000
#define IRAM0_SIZE	0x8000
#define IRAM1_BASE_ADDR	0x80008000
#define IRAM1_SIZE	0x4000

/******************************************************************************/
/* FUNCTION DECLARATIONS		                           												*/
/******************************************************************************/
extern void TargetInit(void);
extern void TargetResetInit( void );
extern void GpioResetInit( void );
/* The IRAM1 test prototyping */
extern void IRAM1SanityCheck( void );

/* A RGU test module needs to be called in startup.s, move these
two modules to target.c to faciliate compatibility with all the
other modules. Only RGU test uses below two modules. */
void Get_RGU_Status( void );
void Get_RGU_SRC_Status( void );

#ifdef __cplusplus
   }
#endif
 
#endif /* end __TARGET_H */
/******************************************************************************
**                            End Of File
******************************************************************************/
